@extends('include.dashboard')
@section('content')

<!-- content @s -->
                <div class="nk-content ">
                    <div class="container wide-xl">
                            <div class="nk-content-body">
                                <div class="nk-content-wrap">
                                    <div class="nk-block-head nk-block-head-lg">
                                        <div class="nk-block-between-md g-4">
                                            <div class="nk-block-head-content">
                                                <h4 class="nk-block-title fw-normal">Choose Suitable MLM Plan</h4>
                                                <div class="nk-block-des">

                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- .nk-block-head -->
                                    <div class="nk-block">
                                        <div class="row g-gs">
                                        @foreach($plans as $data)
                                            <div class="col-md-4">
                                                <div class="price-plan card card-bordered text-center">
                                                    <div class="card-inner">
                                                        <div class="price-plan-media">
                                                            <img src="{{asset('core-img/plan.svg')}}" alt="">
                                                        </div>
                                                        <div class="price-plan-info">
                                                            <h5 class="title">{{$data->name}}</h5>
                                                            <div class="amount h4"><span>{{$basic->currency_sym}}</span>{{number_format($data->price, $basic->decimal)}}
                                                            <span><h6>Referral Bonus: {{$basic->currency_sym}}{{number_format($data->refbonus, $basic->decimal)}}</h6></span></div>

                                                        </div>
                                                        <div class="price-plan-amount">

                                                            <span> @php $total = 0; @endphp
                                                                @foreach($data->plan_level as $key => $lv)
                                                                    @if($key+1 <= $basic->matrix_height)
                                                                        <li>
                                                                            <strong>  @lang('L'.$lv->level.' ')
                                                                            : {{$basic->currency_sym}} {{$lv->amount}}
                                                                            X {{pow($basic->matrix_width,$key+1)}} <i class="fa fa-users"></i> =
                                                                           {{$basic->currency_sym}}{{$lv->amount*pow($basic->matrix_width,$key+1)}}</strong>
                                                                        </li>
                                                                        @php $total += $lv->amount*pow($basic->matrix_width,$key+1); @endphp
                                                                    @endif
                                                                @endforeach
                                                                 <h6>Total: {{$basic->currency_sym}} {{$total}} </h6>


                                @php
                                    $per = intval($total/$data->price*100);
                                @endphp

                                <strong>@lang('Returns')  <span class="sec-color">{{$per}}%</span> @lang('of Price')</strong>

                                                             </span>
                                                        </div>
                                                        <div class="price-plan-action">
                                                            <a href="#confirm-mlm{{$data->id}}"  data-toggle="modal" class="btn btn-primary">Select Plan</a>
                                                        </div>
                                                    </div>
                                                </div><!-- .price-item -->
                                            </div><!-- .col -->


                                              <!-- @@ Confirm Coin Modal @e -->
    <div class="modal fade" tabindex="-1" role="dialog" id="confirm-mlm{{$data->id}}">
        <div class="modal-dialog modal-dialog-centered modal-md" role="document">
            <div class="modal-content">
                <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                <div class="modal-body modal-body-lg text-center">
                    <div class="nk-modal">
                        <em class="nk-modal-icon icon icon-circle icon-circle-xxl ni ni-alert bg-success"></em>
                        <h4 class="nk-modal-title">Plan Price:  {{$basic->currency_sym}}{{number_format($data->price, $basic->decimal)}}</h4>
                        <div class="nk-modal-text">
                            <p class="caption-text">By proceeding with this process, {{__($data->price)}} {{$basic->currency}} will be debited from your deposit balance and
                            you will be subscribed to {{$data->name}} Multilevel Plan</p>
                             </div>
                        <div class="nk-modal-action-lg">
                            <ul class="btn-group gx-4">
                                 <form method="post" action="{{route('plan.purchase')}}">
                            @csrf
                            <div class="modal-sfooter">
                                <button type="submit" name="plan_id" value="{{$data->id}}"
                                        class="btn btn-primary bold uppercase"><i
                                            class="fa fa-send"></i> @lang('Subscribe')</button>
                                <button type="button" class="btn btn-danger" data-dismiss="modal"><i
                                            class="fa fa-times"></i> @lang('Close')</button>
                            </div>
                        </form>
                            </ul>
                        </div>
                    </div>
                </div><!-- .modal-body -->
                <div class="modal-footer bg-lighter">
                    <div class="text-center w-100">
                        <p>Earn upto {{$per}}% in multi level plan by subscribing to this plan!!! <a href="{{route('referral')}}">Invite friends</a></p>
                    </div>
                </div>
            </div><!-- .modal-content -->
        </div><!-- .modla-dialog -->
    </div><!-- .modal -->

                                           @endforeach
                                        </div><!-- .row -->
                                    </div><!-- .nk-block -->

                                </div> </div> </div> </div>
@endsection
